Cobalt Strike's post-exploitation commands can be broken down into 4 broad categories.

-   **House-Keeping**.  These commands set a configuration option in Beacon or do something in the UI, e.g. `clear`, `help` & `note`.  They don't task Beacon to perform an action.
-   **API Only**.  These commands use Win32 APIs and include commands such as `cd`, `cp`, `ls`, `make_token`, and `ps`.
-   **Inline Execution**.  These commands are implemented as [Beacon Object Files](https://hstechdocs.helpsystems.com/manuals/cobaltstrike/current/userguide/content/topics/beacon-object-files_main.htm) (BOFs) which are executed within the Beacon process itself.  `jump psexec/64/psh` and `remote-exec psexec/wmi` are amongst this group.
-   **Fork and Run**.  These commands spawn a temporary process and a post-exploitation DLL is injected into it.  The capability runs and any output is captured over a named pipe.  `execute-assembly`, `powerpick` and `mimikatz` use this pattern.

There are also commands that spawn cmd.exe (`shell`) and powershell.exe by design (`jump winrm/64`, `remote-exec winrm`); and commands that spawn arbitrary processes (`run`, `execute`).  For a full list of which command belongs to which category, see [this page](https://hstechdocs.helpsystems.com/manuals/cobaltstrike/current/userguide/content/topics/appendix-a_beacon-opsec-considerations.htm).

These flavours may have OPSEC concerns in common with each other, and some that are unique to each of them.  This module will explore the detection footprint of these and means to combat.

